Attribute VB_Name = "mdAlignPlanes"
'       This is a part of the source code for Pro/DESKTOP.
'       Copyright (C) 1999-2002 Parametric Technology Corporation.
'       All rights reserved.


Function AlignPlanes(Design As aDesign, firstGeometric As aGeometric, secondGeometric As aGeometric, offset As Double, varName As String)

'Convenince Function to align two planar faces/workplanes so that they face the same way

'Check if the entitied are selected and
'if the selected entities belong to GeometricClass

If firstGeometric Is Nothing Then
    MsgBox ("First Face/Workplane not Selected")
Else
    Dim blnFirstGeometric As Boolean
    blnFirstGeometric = firstGeometric.IsA("Geometric")
End If

If secondGeometric Is Nothing Then
    MsgBox ("Second Face/Workplane not Selected")
Else
    Dim blnSecondGeometric As Boolean
    blnSecondGeometric = secondGeometric.IsA("Geometric")
End If

If (blnFirstGeometric And blnSecondGeometric) Then

    'Get the ProDESKTOP Application object
    GetApplicationObject
    
    'Get the active partDocument
    Dim Part As PartDocument
    Set Part = app.GetActiveDoc
    
    'UpdateDependencies method
    If (secondGeometric.IsDependentOn(firstGeometric)) Then
        Set temp = firstGeometric
        Set firstGeometric = secondGeometric
        Set secondGeometric = temp
    End If
    'end UpdateDependencies
    
    Dim ins As aDesignInstance
    Set ins = firstGeometric.GetParent("DesignInstance")
    
    'Using CreateAbutPlanes to align two planar faces/workplanes so that they face the same way
    Dim mc As zAbutPlanes
    'CreateAbutPlanes takes the reversed parameter as False to create Aligned Planes
    Set mc = app.GetClass("AbutPlanes").CreateAbutPlanes(Design, firstGeometric, secondGeometric, offset, False, varName)
    ins.AddMatingCondition mc
    
Else

MsgBox ("ImProper Selection of Entities")

End If
    
End Function
